@echo off
title Fix PHP Configuration for Email

echo ================================================
echo         FIX PHP CONFIGURATION FOR EMAIL
echo ================================================
echo.

echo This script will help you fix PHP configuration issues.
echo.

echo Current issues found:
echo - Sockets extension not enabled (CRITICAL)
echo - Internationalization extension not enabled (OPTIONAL)
echo.

echo Step 1: Locating php.ini file...
echo.

set PHP_INI_PATH=C:\xampp\php\php.ini

if exist "%PHP_INI_PATH%" (
    echo ✅ Found php.ini at: %PHP_INI_PATH%
) else (
    echo ❌ php.ini not found at expected location
    echo Please locate your php.ini file manually
    echo Common locations:
    echo   - C:\xampp\php\php.ini
    echo   - C:\wamp\bin\apache\apache2.x.x\bin\php.ini
    echo   - C:\php\php.ini
    pause
    exit /b 1
)

echo.
echo Step 2: Creating backup of php.ini...
copy "%PHP_INI_PATH%" "%PHP_INI_PATH%.backup.%date:~-4,4%%date:~-10,2%%date:~-7,2%" >nul
if %errorlevel%==0 (
    echo ✅ Backup created successfully
) else (
    echo ❌ Failed to create backup. Please run as Administrator.
    pause
    exit /b 1
)

echo.
echo Step 3: Checking current extensions...
echo.

findstr /C:"extension=sockets" "%PHP_INI_PATH%" >nul
if %errorlevel%==0 (
    echo ✅ Sockets extension line found in php.ini
    findstr /C:";extension=sockets" "%PHP_INI_PATH%" >nul
    if %errorlevel%==0 (
        echo ⚠️  Sockets extension is commented out (disabled)
        set NEED_SOCKETS_FIX=1
    ) else (
        echo ✅ Sockets extension appears to be enabled
        set NEED_SOCKETS_FIX=0
    )
) else (
    echo ❌ Sockets extension line not found
    set NEED_SOCKETS_FIX=1
)

findstr /C:"extension=intl" "%PHP_INI_PATH%" >nul
if %errorlevel%==0 (
    echo ✅ Intl extension line found in php.ini
    findstr /C:";extension=intl" "%PHP_INI_PATH%" >nul
    if %errorlevel%==0 (
        echo ⚠️  Intl extension is commented out (disabled)
        set NEED_INTL_FIX=1
    ) else (
        echo ✅ Intl extension appears to be enabled
        set NEED_INTL_FIX=0
    )
) else (
    echo ❌ Intl extension line not found
    set NEED_INTL_FIX=1
)

echo.
if "%NEED_SOCKETS_FIX%"=="1" (
    echo Step 4: Fixing sockets extension...
    powershell -Command "(Get-Content '%PHP_INI_PATH%') -replace ';extension=sockets', 'extension=sockets' | Set-Content '%PHP_INI_PATH%'"
    
    findstr /C:"extension=sockets" "%PHP_INI_PATH%" | findstr /V ";" >nul
    if %errorlevel%==0 (
        echo ✅ Sockets extension enabled successfully
    ) else (
        echo ❌ Failed to enable sockets extension automatically
        echo Please edit php.ini manually and uncomment 'extension=sockets'
    )
) else (
    echo ✅ Sockets extension already enabled
)

echo.
if "%NEED_INTL_FIX%"=="1" (
    echo Step 5: Fixing intl extension (optional)...
    powershell -Command "(Get-Content '%PHP_INI_PATH%') -replace ';extension=intl', 'extension=intl' | Set-Content '%PHP_INI_PATH%'"
    
    findstr /C:"extension=intl" "%PHP_INI_PATH%" | findstr /V ";" >nul
    if %errorlevel%==0 (
        echo ✅ Intl extension enabled successfully
    ) else (
        echo ⚠️  Failed to enable intl extension automatically
        echo This is optional - email will still work without it
    )
) else (
    echo ✅ Intl extension already enabled or not needed
)

echo.
echo Step 6: Verifying other important settings...
echo.

findstr /C:"max_execution_time" "%PHP_INI_PATH%" | findstr /V ";" >nul
if %errorlevel%==0 (
    echo ✅ Max execution time setting found
) else (
    echo ⚠️  Max execution time setting not found or commented
)

findstr /C:"memory_limit" "%PHP_INI_PATH%" | findstr /V ";" >nul
if %errorlevel%==0 (
    echo ✅ Memory limit setting found
) else (
    echo ⚠️  Memory limit setting not found or commented
)

echo.
echo ================================================
echo                RESTART REQUIRED
echo ================================================
echo.
echo Changes have been made to php.ini
echo You MUST restart Apache for changes to take effect:
echo.
echo 1. Open XAMPP Control Panel
echo 2. Stop Apache
echo 3. Start Apache
echo 4. Run the PHP requirements checker again
echo.
echo Would you like to:
echo 1. Open XAMPP Control Panel now
echo 2. Run the requirements checker after restart
echo 3. Exit
echo.
set /p restart_choice="Enter your choice (1-3): "

if "%restart_choice%"=="1" (
    echo Opening XAMPP Control Panel...
    start "" "C:\xampp\xampp-control.exe"
    echo Please restart Apache, then run: php setup_guides\check_php_requirements.php
)

if "%restart_choice%"=="2" (
    echo After restarting Apache, run this command:
    echo php setup_guides\check_php_requirements.php
)

echo.
echo ================================================
echo               CONFIGURATION SUMMARY
echo ================================================
echo.
echo Backup created: %PHP_INI_PATH%.backup.%date:~-4,4%%date:~-10,2%%date:~-7,2%
echo.
echo Extensions enabled:
if "%NEED_SOCKETS_FIX%"=="1" echo - Sockets extension (CRITICAL for SMTP)
if "%NEED_INTL_FIX%"=="1" echo - Internationalization extension (OPTIONAL)
echo.
echo Next steps:
echo 1. Restart Apache in XAMPP Control Panel
echo 2. Run: php setup_guides\check_php_requirements.php  
echo 3. Configure email settings in your POS system
echo 4. Test email functionality
echo.
pause 